/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWebServiceCache;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamArray;
import filenet.ws.api.WSParamLeaf;
import filenet.ws.api.WSParamParent;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSSoapHeader;
import filenet.ws.api.WSWSDLRefs;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSOperationInfoHelper;
import filenet.ws.utils.WSSchemaValidatorResult;
import filenet.ws.utils.schema.PESchemaHelper;
import filenet.ws.utils.schema.WSSchemaUtilsEx;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

public class VWWebServiceUtils {
    private static final String PRE_ENDPOINT_REFERENCE = "<wsa:EndPointReference xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\">";
    private static final String POST_ENDPOINT_REFERENCE = "</wsa:EndPointReference>";
    private static final String ADDRESS = "<wsa:Address>OPTIONAL_FINAL_SOAP_ADDRESS</wsa:Address>";
    private static final String PRE_REFERENCE_PROPERTIES = "<wsa:ReferenceProperties>";
    private static final String POST_REFERENCE_PROPERTIES = "</wsa:ReferenceProperties>";
    private static final String PRE_WSDL_ENDPOINT = "<WSDLEndPoint>";
    private static final String POST_WSDL_ENDPOINT = "</WSDLEndPoint>";
    private static final String WSSE_SECURITY_HEADER = "<wsse:Security xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/12/secext\"><wsse:UsernameToken><wsse:Username>USERNAME</wsse:Username><wsse:Password>PASSWORD</wsse:Password></wsse:UsernameToken></wsse:Security>";
    private VWAuthPropertyData m_authPropertyData = null;
    private Hashtable m_schemaCache = new Hashtable();
    private VWWebServiceCache m_webServiceCache = null;

    protected VWWebServiceUtils(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
    }

    protected void reset() {
        this.m_schemaCache.clear();
        PESchemaHelper.ClearCache();
        if (this.m_webServiceCache != null) {
            this.m_webServiceCache.removeAll();
            this.m_webServiceCache = null;
        }
    }

    public boolean isParsableSchema(String schema) {
        if (schema == null) {
            return false;
        }
        if ((schema = schema.trim()).length() == 0 || VWStringUtils.compare(schema.substring(0, 1), "<") != 0) {
            return false;
        }
        try {
            VWStringUtils.xmlPrettyFormat(schema);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getXMLTemplate(String schemaFieldName, String schema, String elementName) {
        try {
            WSSchemaUtilsEx ws = this.retrieveSchema(schema);
            if (ws != null) {
                return ws.getXMLTemplate(schemaFieldName, elementName);
            }
        }
        catch (Exception ex1) {
            // empty catch block
        }
        return null;
    }

    public String getExpressionTemplate(String schemaFieldName, String schema, String elementName) throws Exception {
        WSSchemaUtilsEx ws = this.retrieveSchema(schema);
        if (ws != null) {
            return ws.getExpressionTemplate(schemaFieldName, schema, elementName);
        }
        return null;
    }

    public String[] getElementNamesFromSchema(String schema) throws Exception {
        Object[] elementNames;
        WSSchemaUtilsEx ws = this.retrieveSchema(schema);
        if (ws != null && (elementNames = ws.getSchemaElements()) != null && elementNames.length > 0) {
            VWQubbleSort.sort(elementNames);
            return elementNames;
        }
        return null;
    }

    public String isValidSchema(String schemaName, String schema) throws Exception {
        WSSchemaUtilsEx ws = this.retrieveSchema(schema);
        if (ws != null) {
            WSSchemaValidatorResult validationResult = ws.validate();
            if (!validationResult.getValid()) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), validationResult.getErrors(), VWResource.s_schemaValidationResults, 1);
                return null;
            }
            return ws.getMainSchema();
        }
        return null;
    }

    private WSSchemaUtilsEx retrieveSchema(String schema) throws VWException {
        if (schema == null || schema.trim().length() == 0) {
            return null;
        }
        WSSchemaUtilsEx ws = (WSSchemaUtilsEx)this.m_schemaCache.get(schema = schema.trim());
        if (ws == null) {
            VWSession vwSession = this.m_authPropertyData.getVWSession();
            ws = this.isParsableSchema(schema) ? PESchemaHelper.GetSchemaFromText(vwSession, schema, null) : PESchemaHelper.GetSchemaFromServer(vwSession, schema, null);
            if (ws != null) {
                this.m_schemaCache.put(schema, ws);
            }
        }
        return ws;
    }

    public boolean isSimpleOperation(WSOperation wsOperation) {
        try {
            if (wsOperation != null) {
                if (!this.isSimpleMessage(wsOperation.getFlatInMsgParamList())) {
                    return false;
                }
                if (!this.isSimpleMessage(wsOperation.getFlatOutMsgParamList())) {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public WSOperation[] getOperationsFromPartnerLink(VWPartnerLinkDefinition partnerLinkDef, boolean bDisplayError) {
        try {
            if (partnerLinkDef == null) {
                return null;
            }
            WSDefinition wsDef = this.getDefinitionFromPartnerLink(partnerLinkDef);
            if (wsDef == null) {
                if (this.m_authPropertyData != null && bDisplayError) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_unableToRetrieveOperations, 1);
                }
                return null;
            }
            String portType = partnerLinkDef.getPartnerPortType();
            if (portType == null) {
                if (this.m_authPropertyData != null && bDisplayError) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_portTypeIsNull, 1);
                }
                return null;
            }
            Object[] wsOperations = wsDef.getOperations(portType);
            if (wsOperations != null && wsOperations.length > 0) {
                VWQubbleSort.sort(wsOperations);
                return wsOperations;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public WSOperation getOperationFromPartnerLink(VWPartnerLinkDefinition partnerLinkDef, String operationName) {
        try {
            WSOperation[] wsOperations;
            String portType;
            if (partnerLinkDef == null) {
                return null;
            }
            WSDefinition wsDef = this.getDefinitionFromPartnerLink(partnerLinkDef);
            if (wsDef != null && (portType = partnerLinkDef.getPartnerPortType()) != null && (wsOperations = wsDef.getOperations(portType)) != null) {
                for (int i = 0; i < wsOperations.length; ++i) {
                    if (VWStringUtils.compare(wsOperations[i].getDisplayName(), operationName) != 0) continue;
                    return wsOperations[i];
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public WSDefinition getDefinitionFromPartnerLink(VWPartnerLinkDefinition partnerLinkDef) {
        try {
            if (partnerLinkDef == null) {
                return null;
            }
            WSWSDLRefs wsdlContents = new WSWSDLRefs(partnerLinkDef.getPartnerEndPoint(), partnerLinkDef.getWSDLRef());
            VWWebServiceCache wsCache = this.getWebServiceCache();
            if (wsCache != null) {
                return wsCache.get(wsdlContents.toString());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getPortTypes(String endPoint, JComponent component) {
        try {
            try {
                Object[] portTypes;
                block19: {
                    VWWebServiceCache wsCache;
                    WSDefinition wsDef;
                    block17: {
                        this.m_authPropertyData.displayWaitCursor(component);
                        wsDef = null;
                        wsCache = this.getWebServiceCache();
                        try {
                            block16: {
                                try {
                                    if (endPoint == null || endPoint.length() <= 0 || wsCache == null) break block16;
                                    wsDef = wsCache.get(endPoint);
                                }
                                catch (Exception ex) {
                                    String msg = ex.getLocalizedMessage();
                                    if (msg == null || msg.length() == 0) {
                                        msg = ex.getMessage();
                                    }
                                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), msg, VWResource.s_invalidWSDLURL, 1);
                                    Object var8_7 = null;
                                    this.m_authPropertyData.restoreDefaultCursor(component);
                                    break block17;
                                }
                            }
                            Object var8_6 = null;
                            this.m_authPropertyData.restoreDefaultCursor(component);
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            this.m_authPropertyData.restoreDefaultCursor(component);
                            throw throwable;
                        }
                    }
                    if (wsDef == null) {
                        Object var12_19 = null;
                        this.m_authPropertyData.restoreDefaultCursor(component);
                        return null;
                    }
                    this.m_authPropertyData.displayWaitCursor(component);
                    if (wsCache != null) {
                        wsCache.add(wsDef);
                    }
                    portTypes = null;
                    try {
                        block18: {
                            try {
                                portTypes = this.getSOAPPortTypeNames(wsDef);
                                if (portTypes != null && portTypes.length != 0) break block18;
                                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noSOAPBinding, 1);
                            }
                            catch (Exception ex) {
                                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_invalidWSDLURL, 1);
                                Object var10_15 = null;
                                this.m_authPropertyData.restoreDefaultCursor(component);
                                break block19;
                            }
                        }
                        Object var10_14 = null;
                        this.m_authPropertyData.restoreDefaultCursor(component);
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        this.m_authPropertyData.restoreDefaultCursor(component);
                        throw throwable;
                    }
                }
                if (portTypes != null && portTypes.length > 0) {
                    VWQubbleSort.sort(portTypes);
                }
                Object[] objectArray = portTypes;
                Object var12_18 = null;
                this.m_authPropertyData.restoreDefaultCursor(component);
                return objectArray;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var12_20 = null;
                this.m_authPropertyData.restoreDefaultCursor(component);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            this.m_authPropertyData.restoreDefaultCursor(component);
            throw throwable;
        }
    }

    public void createInvokeParameters(VWInvokeInstruction instructionDef, WSOperation wsOperation, boolean bIncoming) {
        if (wsOperation == null) {
            return;
        }
        WSParam[] flatParams = null;
        flatParams = bIncoming ? wsOperation.getFlatOutMsgParamList() : wsOperation.getFlatInMsgParamList();
        if (flatParams != null) {
            for (int i = 0; i < flatParams.length; ++i) {
                VWFieldDefinition fieldDef;
                WSParam[] wsChildren;
                WSParam wsParam = flatParams[i];
                if (wsParam == null) continue;
                int nType = wsParam.getType();
                int nSubType = wsParam.getSubType();
                String paramValue = null;
                WSParam wsChild = null;
                boolean bIsArray = wsParam.isArray();
                if (nType == -1) {
                    nType = 2;
                    paramValue = null;
                } else if (nType == 2 && wsParam.isAttachmentReference()) {
                    nType = 32;
                }
                if (wsParam.isArrayParent() && wsParam instanceof WSParamParent && (wsChildren = ((WSParamParent)wsParam).getChildren()) != null && wsChildren.length > 0 && (wsChild = wsChildren[0]) != null) {
                    nType = wsChild.getType();
                    nSubType = wsChild.getSubType();
                    if (nType == 2 && wsParam.isAttachmentReference()) {
                        nType = 32;
                    }
                    bIsArray = true;
                }
                if ((fieldDef = this.m_authPropertyData.getField(wsParam.getName())) != null && fieldDef.getFieldType() == nType && fieldDef.isArray() == bIsArray) {
                    paramValue = wsParam.getName();
                }
                if (this.isValidVWType(nType, nSubType)) {
                    try {
                        VWWebServiceParameterDefinition wsParamDef = null;
                        wsParamDef = bIncoming ? instructionDef.createInComingParameter(wsParam.getName(), paramValue, nType, bIsArray) : instructionDef.createOutGoingParameter(wsParam.getName(), paramValue, nType, bIsArray);
                        if (wsParamDef == null) continue;
                        wsParamDef.setAttributes(wsParam.getAttribute());
                        wsParamDef.setLexicalLevel(wsParam.getLevel());
                        wsParamDef.setNameSpace(wsParam.getNamespace());
                        wsParamDef.setSchemaSubType(wsParam.getSubType());
                        wsParamDef.setSequenceNumber(i);
                        if (nType == 32) {
                            wsParamDef.setAttachmentByValue(!wsParam.isAttachmentReference());
                        }
                        if (wsChild != null && wsChild instanceof WSParamArray) {
                            wsParamDef.setArrayAttributes(((WSParamArray)wsChild).getArrayElementAttribute());
                            wsParamDef.setArrayNameSpace(((WSParamArray)wsChild).getArrayElementNamespace());
                            wsParamDef.setArrayTag(((WSParamArray)wsChild).getArrayElementName());
                            continue;
                        }
                        if (!wsParam.isArray()) continue;
                        wsParamDef.setArrayAttributes(wsParam.getAttribute());
                        wsParamDef.setArrayNameSpace(wsParam.getNamespace());
                        wsParamDef.setArrayTag(wsParam.getName());
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                    continue;
                }
                System.out.println("Error creating parameter: " + wsParam);
            }
        }
    }

    public void updateInvokeInstruction(WSOperation wsOperation, VWInvokeInstruction invokeInst) {
        try {
            if (wsOperation != null) {
                invokeInst.setInputMsgName(wsOperation.getInputName());
                invokeInst.setOutputMsgName(wsOperation.getOutputName());
                if (this.isSimpleOperation(wsOperation)) {
                    VWWebServiceParameterDefinition[] oldIncomingParamDefs = invokeInst.getInComingParameterDefinitions();
                    VWWebServiceParameterDefinition[] oldOutgoingParamDefs = invokeInst.getOutGoingParameterDefinitions();
                    invokeInst.setInputMsgExpr(null);
                    invokeInst.setOutputMsgExpr(null);
                    invokeInst.deleteAllParameters();
                    this.createInvokeParameters(invokeInst, wsOperation, true);
                    this.createInvokeParameters(invokeInst, wsOperation, false);
                    VWWebServiceParameterDefinition[] newIncomingParamDefs = invokeInst.getInComingParameterDefinitions();
                    if (oldIncomingParamDefs != null && newIncomingParamDefs != null) {
                        block2: for (int nNewIndex = 0; nNewIndex < newIncomingParamDefs.length; ++nNewIndex) {
                            for (int nOldIndex = 0; nOldIndex < oldIncomingParamDefs.length; ++nOldIndex) {
                                if (VWStringUtils.compare(oldIncomingParamDefs[nOldIndex].getName(), newIncomingParamDefs[nNewIndex].getName()) != 0) continue;
                                newIncomingParamDefs[nNewIndex].setValue(oldIncomingParamDefs[nOldIndex].getValue());
                                continue block2;
                            }
                        }
                    }
                    VWWebServiceParameterDefinition[] newOutgoingParamDefs = invokeInst.getOutGoingParameterDefinitions();
                    if (oldOutgoingParamDefs != null && newOutgoingParamDefs != null) {
                        block4: for (int nNewIndex = 0; nNewIndex < newOutgoingParamDefs.length; ++nNewIndex) {
                            for (int nOldIndex = 0; nOldIndex < oldOutgoingParamDefs.length; ++nOldIndex) {
                                if (VWStringUtils.compare(oldOutgoingParamDefs[nOldIndex].getName(), newOutgoingParamDefs[nNewIndex].getName()) != 0) continue;
                                newOutgoingParamDefs[nNewIndex].setValue(oldOutgoingParamDefs[nOldIndex].getValue());
                                continue block4;
                            }
                        }
                    }
                } else {
                    invokeInst.deleteAllParameters();
                    invokeInst.setInputMsgExpr(wsOperation.getExpressionInMessageTemplate());
                }
            } else {
                invokeInst.setOperationName(null);
                invokeInst.setInputMsgName(null);
                invokeInst.setOutputMsgName(null);
                invokeInst.deleteAllParameters();
                invokeInst.setInputMsgExpr(null);
                invokeInst.setOutputMsgExpr(null);
                invokeInst.setInputCorrelationSetName(null);
                invokeInst.setInputCorrelationSetProperties(null);
                invokeInst.setOutputCorrelationSetName(null);
                invokeInst.setOutputCorrelationSetProperties(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getHeaderInformation(VWPartnerLinkDefinition partnerLinkDef, WSOperation wsOperation) {
        String header = null;
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(PRE_ENDPOINT_REFERENCE);
            buf.append(ADDRESS);
            String endPoint = partnerLinkDef.getPartnerEndPoint();
            buf.append(PRE_WSDL_ENDPOINT + endPoint + POST_WSDL_ENDPOINT);
            buf.append(PRE_REFERENCE_PROPERTIES);
            if (this.isPEWSI(endPoint)) {
                buf.append(WSSE_SECURITY_HEADER);
            } else {
                String portType;
                WSDefinition wsDef = this.getDefinitionFromPartnerLink(partnerLinkDef);
                if (wsDef != null && wsOperation != null && (portType = partnerLinkDef.getPartnerPortType()) != null && portType.length() > 0) {
                    WSOperationInfoHelper opInfoHelper;
                    WSPort wsPort = wsDef.getDefaultPort(portType);
                    WSBindingOperation wsBinding = wsPort.getBindingOperation(wsOperation.getDisplayName(), wsOperation.getInputName(), wsOperation.getOutputName());
                    WSSoapHeader[] headers = wsBinding.getSoapInHeaders();
                    if (this.isProcessOrchestrationOp(wsBinding) && (opInfoHelper = WSOperationInfoHelper.getWSOperationInfoHelper(wsOperation)) != null && opInfoHelper.getAuthentication()) {
                        buf.append(WSSE_SECURITY_HEADER);
                    }
                    if (headers != null) {
                        for (int i = 0; i < headers.length; ++i) {
                            buf.append(headers[i].getTemplate());
                        }
                    }
                }
            }
            buf.append(POST_REFERENCE_PROPERTIES);
            buf.append(POST_ENDPOINT_REFERENCE);
            try {
                header = buf.toString();
                header = VWStringUtils.xmlPrettyFormat(header);
            }
            catch (Exception ex) {
                // empty catch block
            }
            header = "F_EndPointRef" + partnerLinkDef.getName() + "=" + header;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return header;
    }

    private VWWebServiceCache getWebServiceCache() {
        if (this.m_webServiceCache == null) {
            this.m_webServiceCache = new VWWebServiceCache(this.m_authPropertyData.getVWSession());
        }
        return this.m_webServiceCache;
    }

    private boolean isSimpleMessage(WSParam[] flatParams) {
        try {
            if (flatParams == null) {
                return true;
            }
            Hashtable<String, Integer> nameCollection = new Hashtable<String, Integer>();
            Integer dummyValue = new Integer(-1);
            for (int i = 0; i < flatParams.length; ++i) {
                WSParam[] wsChildren;
                WSParam wsParam = flatParams[i];
                if (wsParam == null) {
                    return false;
                }
                if (wsParam.getLevel() > 1 && wsParam.getType() != -1 && !this.isValidVWType(wsParam.getType(), wsParam.getSubType())) {
                    return false;
                }
                if (wsParam instanceof WSParamLeaf) {
                    if (((WSParamLeaf)wsParam).isEnumType()) {
                        return false;
                    }
                    if (((WSParamLeaf)wsParam).isAttribute()) {
                        return false;
                    }
                }
                if (wsParam.getName() == null || nameCollection.containsKey(wsParam.getName())) {
                    return false;
                }
                nameCollection.put(wsParam.getName(), dummyValue);
                if (!wsParam.isArrayParent() || !(wsParam instanceof WSParamParent) || (wsChildren = ((WSParamParent)wsParam).getChildren()) == null) continue;
                if (wsChildren.length > 1) {
                    return false;
                }
                for (int j = 0; j < wsChildren.length; ++j) {
                    WSParam wsChild = wsChildren[j];
                    if (wsChild != null && wsChild instanceof WSParamArray) {
                        if (!this.isValidVWType(wsChild.getType(), wsChild.getSubType())) {
                            return false;
                        }
                        if (nameCollection.containsKey(wsChild.getName())) continue;
                        nameCollection.put(wsChild.getName(), dummyValue);
                        continue;
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    private boolean isValidVWType(int nType, int nSubType) {
        switch (nType) {
            case 32: {
                switch (nSubType) {
                    case -1: 
                    case 0: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                break;
            }
            case 4: {
                switch (nSubType) {
                    case -1: 
                    case 21: {
                        return true;
                    }
                }
                break;
            }
            case 8: {
                switch (nSubType) {
                    case -1: 
                    case 18: 
                    case 19: 
                    case 20: {
                        return true;
                    }
                }
                break;
            }
            case 1: {
                switch (nSubType) {
                    case -1: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 128: {
                switch (nSubType) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 2: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: {
                        return true;
                    }
                }
                break;
            }
            case 16: {
                switch (nSubType) {
                    case -1: 
                    case 22: 
                    case 23: 
                    case 25: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String[] getSOAPPortTypeNames(WSDefinition wsDef) {
        WSPortType[] wsPortTypes = wsDef.getPortTypes();
        if (wsPortTypes == null || wsPortTypes.length == 0) {
            return null;
        }
        Vector<String> soapPortTypes = new Vector<String>(1);
        for (int i = 0; i < wsPortTypes.length; ++i) {
            String portTypeName = wsPortTypes[i].getName();
            WSPort wsPort = wsDef.getDefaultPort(portTypeName);
            if (wsPort != null) {
                WSBinding wsBinding = wsPort.getBinding();
                if (wsBinding == null || wsBinding.getSoapBinding() == null) continue;
                soapPortTypes.add(portTypeName);
                continue;
            }
            soapPortTypes.add(portTypeName);
        }
        return soapPortTypes.toArray(new String[0]);
    }

    private boolean isPEWSI(String url) {
        return url != null && url.indexOf("ProcessEngineWS") != -1;
    }

    private boolean isProcessOrchestrationOp(WSBindingOperation wsBindingOp) {
        if (wsBindingOp != null) {
            try {
                P8BPMSoapActionURI soapActionURI = new P8BPMSoapActionURI(wsBindingOp.getSoapAction());
                return soapActionURI != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

